<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>YouTube Video Carousel</title>

    <!-- Owl Carousel CSS -->
    <link rel="stylesheet"
        href="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/assets/owl.carousel.min.css" />
    <link rel="stylesheet"
        href="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/assets/owl.theme.default.min.css" />

    <style>
        body {
            margin: 0;
            background: #121212;
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
        }

        .mobile-frame {
            width: 300px;
            height: 600px;
            border: 16px solid #333;
            border-radius: 40px;
            overflow: hidden;
            box-shadow: 0 0 30px rgba(0, 0, 0, 0.6);
            background: black;
            position: relative;
        }

        .video-container {
            width: 100%;
            height: 100%;
            position: relative;
        }

        .video-container iframe {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            border: none;
        }

        .owl-carousel .item {
            width: 100%;
            height: 100%;
        }

        .video-container {
            width: 100%;
            height: 100%;
        }

        iframe {
            width: 100%;
            height: 100%;
            border: none;
        }

        .controls {
            position: absolute;
            top: 50%;
            width: 100%;
            display: flex;
            justify-content: space-between;
            transform: translateY(-50%);
            /* padding: 0 10px; */
            pointer-events: none;
        }

        .controls button {
            background: rgba(255, 255, 255, 0.8);
            border: none;
            border-radius: 50%;
            width: 40px;
            height: 40px;
            font-size: 20px;
            cursor: pointer;
            pointer-events: all;
            transition: 0.3s ease;
        }

        .controls button:hover {
            background: #fff;
        }
    </style>
</head>

<body>

    <div class="mobile-frame">
        <div class="owl-carousel" id="video-carousel">
            <div class="item" data-index="0">
                <div class="video-container">
                    <div id="player1"></div>
                </div>
            </div>
            <div class="item" data-index="1">
                <div class="video-container">
                    <div id="player2"></div>
                </div>
            </div>
            <div class="item" data-index="2">
                <div class="video-container">
                    <div id="player3"></div>
                </div>
            </div>
        </div>

        <!-- Prev/Next Controls -->
        <div class="controls">
            <button id="prev">&#8249;</button>
            <button id="next">&#8250;</button>
        </div>
    </div>

    <!-- jQuery + Owl Carousel -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/owl.carousel.min.js"></script>

    <!-- YouTube Iframe API -->
    <script src="https://www.youtube.com/iframe_api"></script>

    <script>
        let players = [];
        let carousel;

        function onYouTubeIframeAPIReady() {
            players[0] = new YT.Player('player1', {
                videoId: 'jvN5wWpijxs',
                playerVars: { 'autoplay': 0, 'controls': 1 },
            });
            players[1] = new YT.Player('player2', {
                videoId: 'tgbNymZ7vqY',
                playerVars: { 'autoplay': 0, 'controls': 1 },
            });
            players[2] = new YT.Player('player3', {
                videoId: 'Z1BCujX3pw8',
                playerVars: { 'autoplay': 0, 'controls': 1 },
            });

            initializeCarousel();
        }

        function initializeCarousel() {
            carousel = $('#video-carousel');

            carousel.owlCarousel({
                items: 1,
                loop: true,
                nav: false,
                dots: false,
                smartSpeed: 600,
                onInitialized: controlVideo,
                onTranslated: controlVideo
            });

            $('#next').click(() => carousel.trigger('next.owl.carousel'));
            $('#prev').click(() => carousel.trigger('prev.owl.carousel'));
        }

        function controlVideo(event) {
            let total = players.length;
            let index = (event.item.index - event.relatedTarget._clones.length / 2 + total) % total;

            players.forEach((player, i) => {
                if (player && typeof player.pauseVideo === "function") {
                    if (i === index) player.playVideo();
                    else player.pauseVideo();
                }
            });
        }
    </script>

</body>

</html>