<div class="form_01 my-md-3 w-100 bg-white p-md-5 p-3">
    <form class="enqui_form_ai" action="" method="post">
        <div class="">
            <div class="row">
                <div class="col-md-12  mb-3">
                    <input type="text" class="form-control -sm border-rounded" placeholder="FULL NAME*" name="fname"
                        required>
                </div>
                <div class="col-md-12  mb-3">
                    <input type="text" class="form-control -sm border-rounded" placeholder="PHONE NUMBER*" name="phone"
                        required>
                </div>
                <div class="col-md-12 mb-3">
                    <input type="text" class="form-control -sm border-rounded" placeholder="EMAIL ADDRESS*" name="email"
                        required>
                </div>
                <div class="col-md-6 mb-3">
                    <div class="form-group">
                        <select class="form-control bg-white" id="state" name="state">
                            <option selected disabled>SELECT STATE</option>
                        </select>
                    </div>
                </div>
                <div class="col-md-6 mb-3">
                    <div class="form-group">

                        <select class="form-control -sm border-rounded" id="city" name="city" disabled>
                            <option value="" disabled selected>SELECT CITY</option>
                        </select>
                    </div>
                </div>


                <!-- Dummy Courses Dropdown Section -->
                <div class="col-md-12 mb-3">
                    <div class="form-group">
                        <label for="selected-courses" required>(Choose Upto 3 Courses):</label>
                        <div class="dropdown">
                            <button class="btn bg-white dropdown-toggle w-100 text-start" type="button"
                                id="dropdownMenuButton" data-bs-toggle="dropdown" aria-expanded="false">
                                SELECT COURSES
                            </button>


                            <ul class="dropdown-menu p-2" aria-labelledby="dropdownMenuButton"
                                style="max-height: 200px; overflow-y: auto;">
                                <li><label><input type="checkbox" value="Course 1"> HR and Recruitment </label></li>
                                <li><label><input type="checkbox" value="Course 2"> Financial Analyst </label></li>
                                <li><label><input type="checkbox" value="Course 3"> Accounts Executive </label></li>
                                <li><label><input type="checkbox" value="Course 4"> Logistics Coordinator /
                                        Specialist</label></li>
                                <li><label><input type="checkbox" value="Course 5"> Global Banking Operations
                                        Executive</label></li>
                                <li><label><input type="checkbox" value="Course 6"> Market Researcher</label></li>
                                <li><label><input type="checkbox" value="Course 6"> Securities Market</label></li>

                                <li><label><input type="checkbox" value="Course 6"> Customer Support</label></li>
                                <li><label><input type="checkbox" value="Course 6"> Business Analyst</label></li>


                            </ul>

                        </div>
                        <div id="selected-courses" class="mt-2 p-2 ">
                            <!-- Selected courses will be displayed here -->
                        </div>
                    </div>
                </div>
                <div class="col-md-12 mb-3">
                    <div class="form-check">
                        <input type="checkbox" class="form-check-input" id="agree" name="agree" required>
                        <label class="form-check-label fw-bold" for="agree">I agree to be considered for any other
                            Course.</label>
                    </div>
                </div>

                <div class="mt-4 d-flex justify-content-center">

                    <button type="button" class="xsubmit-btn">SUBMIT</>

                </div>
            </div>
        </div>
    </form>
</div>

<!-- JavaScript to enforce max 3 selections and update selected courses -->
<script>
    const checkboxes = document.querySelectorAll('.dropdown-menu input[type="checkbox"]');
    const selectedCoursesDiv = document.getElementById('selected-courses');

    // Create an error message element
    const errorMsg = document.createElement('div');
    errorMsg.className = 'text-danger mt-2';
    errorMsg.style.display = 'none'; // Hidden by default
    selectedCoursesDiv.parentNode.appendChild(errorMsg);

    function updateSelectedCourses() {
        const selected = document.querySelectorAll('.dropdown-menu input[type="checkbox"]:checked');
        selectedCoursesDiv.innerHTML = '';
        errorMsg.style.display = 'none'; // Hide error message by default

        // Display selected courses as badges with remove buttons
        selected.forEach(checkbox => {
            const badge = document.createElement('span');
            badge.className = 'badge me-2 p-2';
            badge.textContent = checkbox.parentElement.textContent.trim();

            // Add a remove button to each badge
            const removeBtn = document.createElement('button');
            removeBtn.className = 'btn-close btn-close-white ms-2';
            removeBtn.style.fontSize = '0.75rem';
            removeBtn.addEventListener('click', () => {
                checkbox.checked = false; // Uncheck the corresponding checkbox
                updateSelectedCourses(); // Update the displayed courses
            });

            badge.appendChild(removeBtn);
            selectedCoursesDiv.appendChild(badge);
        });
    }

    checkboxes.forEach(checkbox => {
        checkbox.addEventListener('change', () => {
            const selected = document.querySelectorAll('.dropdown-menu input[type="checkbox"]:checked');

            if (selected.length > 3) {
                // Show the error message
                errorMsg.textContent = 'You can only select up to 3 courses.';
                errorMsg.style.display = 'block';

                // Uncheck the last selected checkbox
                checkbox.checked = false;
                return;
            }

            updateSelectedCourses();
        });
    });

    // Initialize the selected courses display
    updateSelectedCourses();


    document.addEventListener("DOMContentLoaded", () => {
        const stateDropdown = document.getElementById("state");
        const cityDropdown = document.getElementById("city");

        // Fetch the JSON file
        fetch("city.json")
            .then(response => {
                if (!response.ok) {
                    throw new Error("Failed to load city.json");
                }
                return response.json();
            })
            .then(data => {
                populateStates(data);
            })
            .catch(error => {
                console.error("Error:", error);
                alert("Failed to load city data. Please try again later.");
            });

        // Populate states in the dropdown
        function populateStates(stateCityData) {
            // Sort states alphabetically
            const sortedStates = Object.keys(stateCityData).sort((a, b) => a.localeCompare(b));

            // Create and append state options
            sortedStates.forEach(state => {
                const option = document.createElement("option");
                option.value = state;
                option.textContent = state;
                stateDropdown.appendChild(option);
            });

            // Add change event listener for the state dropdown
            stateDropdown.addEventListener("change", function () {
                const selectedState = this.value;

                // Reset and disable the city dropdown
                cityDropdown.innerHTML = '<option value="" disabled selected>SELECT CITY</option>';
                cityDropdown.disabled = true;

                // Populate city dropdown based on selected state
                if (selectedState && stateCityData[selectedState]) {
                    const cities = stateCityData[selectedState];

                    // Sort cities alphabetically
                    cities.sort((a, b) => a.localeCompare(b));

                    if (cities.length === 0) {
                        const option = document.createElement("option");
                        option.value = "";
                        option.textContent = "No cities available";
                        cityDropdown.appendChild(option);
                    } else {
                        cities.forEach(city => {
                            const option = document.createElement("option");
                            option.value = city;
                            option.textContent = city;
                            cityDropdown.appendChild(option);
                        });
                    }

                    // Enable the city dropdown
                    cityDropdown.disabled = false;
                }
            });
        }
    });





</script>